/*
 * Decompiled with CFR 0.152.
 */
package D88File;

import D88File.DiskResult;
import D88File.DiskResultSet;
import D88File.FileResult;
import D88File.FileResultSet;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class D88File {
    private String mstrClassName = new String("D88File.class");
    private String mstrThisVer = new String("0.05");
    private String mstrCopyright = new String("Copyright (C) AKATTA ,2002-2004");
    private String mstrEncoding = new String("");
    private String mstrSeparator = new String("");
    private File mfileD88;
    private File mfileD88BackUp;
    private File mfileD88RollBack;
    private boolean mblnCheckOK = true;
    private String mstrErrMsg = new String("");
    private boolean mblnBackupFlag;
    private boolean mblnCommitFlag;
    private boolean mblnTranFlag;
    private int mintDiskCount;
    private String mstrDiskName = new String("");
    private int mintWriteProtect;
    private int mintDiskType;
    private int mintDiskSize;
    private long[] mlngFileTracks = new long[164];

    public D88File(File file, int n) {
        this.mfileD88 = file;
        this.mblnCheckOK = this.initCheck();
    }

    public D88File(String string, int n) {
        this.mfileD88 = new File(string);
        this.mblnCheckOK = this.initCheck();
    }

    public String getVersion() {
        return this.mstrThisVer;
    }

    public String getCopyright() {
        return this.mstrCopyright;
    }

    public String getClassName() {
        return this.mstrClassName;
    }

    private boolean initCheck() {
        System.out.println(this.mstrClassName + "  Ver. " + this.mstrThisVer + "  " + this.mstrCopyright);
        this.initEncoding();
        this.mstrSeparator = System.getProperty("file.separator");
        this.mintDiskCount = this.checkD88File(this.mfileD88, 0, true);
        switch (this.mintDiskCount) {
            case -1: {
                return false;
            }
            case 0: {
                return false;
            }
        }
        this.mblnBackupFlag = false;
        this.mblnCommitFlag = false;
        this.mblnTranFlag = false;
        return true;
    }

    private void initEncoding() {
        try {
            String string = new String("MS932 Encoding Enable!".getBytes("MS932"), "MS932");
            this.mstrEncoding = "MS932";
        }
        catch (Exception exception) {
            this.mstrEncoding = System.getProperty("file.encoding");
        }
    }

    public boolean isValid() {
        return this.mblnCheckOK;
    }

    public String getErrMsg() {
        return this.mstrErrMsg;
    }

    public String getEncoding() {
        return this.mstrEncoding;
    }

    public String getD88FilePath() {
        try {
            return this.mfileD88.getCanonicalPath();
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getD88FilePath Error. Not Found?";
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] parseNumRange(String string, int n, int n2) {
        int[] nArray;
        int[] nArray2 = new int[]{};
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        try {
            int[] nArray3;
            if (n != 1 && n != 2 && n != 3) {
                this.mstrErrMsg = "parseNumRange intType error";
                return nArray2;
            }
            if (!this.checkNumRange(string)) {
                this.mstrErrMsg = "parseNumRange NumRange invalid";
                return nArray2;
            }
            if (n2 == 0) {
                n3 = 64;
            } else if (n2 >= 1 && n2 <= 64) {
                n3 = 256;
                FileResultSet fileResultSet = this.listFile(n2);
                n4 = fileResultSet.getMaxRows();
                if (n4 < 1) {
                    this.mstrErrMsg = "parseNumRange DiskImage UnRecoganized";
                    return nArray2;
                }
            } else {
                this.mstrErrMsg = "parseNumRange DiskCount Invalid";
                return nArray2;
            }
            nArray = new int[n3];
            if (this.mintDiskCount == 0) {
                this.mstrErrMsg = "parseNumRange DiskCount Invalid";
                return nArray2;
            }
            n5 = string.indexOf("-");
            if (n5 != -1) {
                if (n != 1) {
                    this.mstrErrMsg = "parseNumRange: - invalid charactor";
                    return nArray2;
                }
                if (string.indexOf("-", n5 + 1) != -1) {
                    this.mstrErrMsg = "parseNumRange: - is only single use";
                    return nArray2;
                }
                if (string.indexOf(",", n5) != -1) {
                    this.mstrErrMsg = "parseNumRange: - and  , with not use.";
                    return nArray2;
                }
                n7 = new Integer(string.substring(0, string.indexOf("-")));
                if (n7 >= (n8 = new Integer(string.substring(string.indexOf("-") + 1)).intValue())) {
                    this.mstrErrMsg = "parseNumRange: Begin >= End";
                    return nArray2;
                }
                if (!(n7 >= 1 && n7 <= n3 || n8 >= 1 && n8 <= n3)) {
                    this.mstrErrMsg = "parseNumRange: use 1 thru " + n3 + "!";
                    return nArray2;
                }
                if (n2 == 0) {
                    if (n8 > this.mintDiskCount) {
                        this.mstrErrMsg = "parseNumRange: DiskCount Over!: " + n8;
                        return nArray2;
                    }
                } else if (n8 > n4) {
                    this.mstrErrMsg = "parseNumRange: FileCount Over!: " + n8;
                    return nArray2;
                }
                nArray3 = new int[n8 - n7 + 1];
                for (n5 = 0; n5 < nArray3.length; ++n5) {
                    nArray3[n5] = n7 + n5;
                }
                return nArray3;
            }
            if (string.indexOf(",") != -1) {
                if (n != 1) {
                    this.mstrErrMsg = "parseNumRange: , invalid charactor";
                    return nArray2;
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    nArray[n5] = 0;
                }
            } else {
                n5 = new Integer(string);
                if (n5 == 0) {
                    if (n == 3) {
                        this.mstrErrMsg = "parseNumRange: 0 not Selected: " + n5;
                        return nArray2;
                    }
                    if (n2 == 0) {
                        nArray3 = new int[this.mintDiskCount];
                        for (n5 = 0; n5 < this.mintDiskCount; ++n5) {
                            nArray3[n5] = n5 + 1;
                        }
                        return nArray3;
                    } else {
                        nArray3 = new int[n4];
                        for (n5 = 0; n5 < n4; ++n5) {
                            nArray3[n5] = n5 + 1;
                        }
                    }
                    return nArray3;
                }
                if (n5 < 1 || n5 > n3) {
                    this.mstrErrMsg = "parseNumRange: use 1 thru intNumberLimited!: " + n5;
                    return nArray2;
                }
                if (n2 == 0) {
                    if (n5 > this.mintDiskCount) {
                        this.mstrErrMsg = "parseNumRange: DiskCount Over!: " + n5;
                        return nArray2;
                    }
                } else if (n5 > n4) {
                    this.mstrErrMsg = "parseNumRange: FileCount Over!: " + n5;
                    return nArray2;
                }
                nArray3 = new int[]{n5};
                return nArray3;
            }
            n7 = 0;
            n8 = 0;
            n6 = 0;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "parseNumRange Other Error...";
            return nArray2;
        }
        while (true) {
            if (n8 != -1) {
                n8 = string.indexOf(",", n7);
                n9 = n8 == -1 ? new Integer(string.substring(n7)).intValue() : new Integer(string.substring(n7, n8)).intValue();
            } else {
                int[] nArray4 = new int[n6];
                n5 = 0;
                while (true) {
                    if (n5 >= nArray4.length) {
                        return nArray4;
                    }
                    nArray4[n5] = nArray[n5];
                    ++n5;
                }
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (n9 != nArray[n5]) continue;
                this.mstrErrMsg = "parseNumRange: tyofuku Number Error: " + n9;
                return nArray2;
            }
            if (n2 == 0) {
                if (n9 > this.mintDiskCount) {
                    this.mstrErrMsg = "parseNumRange: tyofuku Number Error: " + n9;
                    return nArray2;
                }
            } else if (n9 > n4) {
                this.mstrErrMsg = "parseNumRange: tyofuku Number Error: " + n9;
                return nArray2;
            }
            nArray[n6] = n9;
            n7 = n8 + 1;
            ++n6;
        }
    }

    private boolean checkNumRange(String string) {
        int n = 0;
        try {
            for (n = 0; n < string.length(); ++n) {
                if (string.substring(n, n + 1).equals("0") || string.substring(n, n + 1).equals("1") || string.substring(n, n + 1).equals("2") || string.substring(n, n + 1).equals("3") || string.substring(n, n + 1).equals("4") || string.substring(n, n + 1).equals("5") || string.substring(n, n + 1).equals("6") || string.substring(n, n + 1).equals("7") || string.substring(n, n + 1).equals("8") || string.substring(n, n + 1).equals("9") || string.substring(n, n + 1).equals(",") || string.substring(n, n + 1).equals("-")) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
    }

    private int checkD88File(File file, int n, boolean bl) {
        boolean bl2 = false;
        try {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    if (file.canRead()) {
                        if (file.getName().lastIndexOf(".") != 0) {
                            if (file.getName().lastIndexOf(".") != file.getName().length() - 1) {
                                if (n == 1 && !file.canWrite()) {
                                    this.mstrErrMsg = "checkD88File ObjectFile not can Write";
                                } else {
                                    bl2 = true;
                                }
                            } else {
                                this.mstrErrMsg = "checkD88File ObjectFile . end";
                            }
                        } else {
                            this.mstrErrMsg = "checkD88File ObjectFile . start";
                        }
                    } else {
                        this.mstrErrMsg = "checkD88File ObjectFile not can read";
                    }
                } else {
                    this.mstrErrMsg = "checkD88File ObjectFile is Directory";
                }
            } else {
                this.mstrErrMsg = "checkD88File ObjectFile not Exist";
            }
            if (bl2) {
                if (bl) {
                    DiskResultSet diskResultSet = this.listDisk();
                    return diskResultSet.getMaxRows();
                }
                return 0;
            }
            return -1;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "checkD88File Other Error...";
            return -1;
        }
    }

    private boolean checkDiskHeader(RandomAccessFile randomAccessFile, long l) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        byte[] byArray3 = new byte[10];
        int[] nArray = new int[4];
        int n = 0;
        try {
            randomAccessFile.seek(l);
            randomAccessFile.readFully(byArray);
            if (this.mstrEncoding.equals("MS932")) {
                boolean bl = false;
                for (n = 0; n <= 15; ++n) {
                    if (bl) {
                        byArray[n] = 32;
                        continue;
                    }
                    if (byArray[n] != 0) continue;
                    bl = true;
                    byArray[n] = 32;
                }
                this.mstrDiskName = new String(byArray, this.mstrEncoding);
            } else {
                this.mstrDiskName = this.alterFileName(byArray);
                byArray = this.mstrDiskName.getBytes(this.mstrEncoding);
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.mstrDiskName = new String(byArray2, this.mstrEncoding);
            }
            randomAccessFile.readFully(byArray3);
            this.mintWriteProtect = randomAccessFile.readUnsignedByte();
            this.mintDiskType = randomAccessFile.readUnsignedByte();
            nArray[0] = randomAccessFile.readUnsignedByte();
            nArray[1] = randomAccessFile.readUnsignedByte();
            nArray[2] = randomAccessFile.readUnsignedByte();
            nArray[3] = randomAccessFile.readUnsignedByte();
            this.mintDiskSize = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
            for (n = 0; n <= 163; ++n) {
                nArray[0] = randomAccessFile.readUnsignedByte();
                nArray[1] = randomAccessFile.readUnsignedByte();
                nArray[2] = randomAccessFile.readUnsignedByte();
                nArray[3] = randomAccessFile.readUnsignedByte();
                this.mlngFileTracks[n] = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
            }
            switch (this.mintWriteProtect) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    this.mstrErrMsg = "checkDiskHeader WriteProtectFlag Error...";
                    return false;
                }
            }
            switch (this.mintDiskType) {
                case 0: 
                case 16: 
                case 32: {
                    break;
                }
                default: {
                    this.mstrErrMsg = "checkDiskHeader DiskTypeFlag Error...";
                    return false;
                }
            }
            if (this.mintDiskSize < 688 || this.mintDiskSize > 10000000) {
                this.mstrErrMsg = "checkDiskHeader DiskSize < 688 or > 10000000";
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "checkDiskHeader Other Error...";
            return false;
        }
    }

    private int checkDiskFormat(RandomAccessFile randomAccessFile, long l) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[24];
        byte[] byArray2 = new byte[78];
        String string = new String("");
        try {
            if (!this.checkDiskHeader(randomAccessFile, l)) {
                return -1;
            }
            if (this.mintDiskType != 0) {
                return 0;
            }
            byte[] byArray3 = null;
            byArray3 = this.readSectors(randomAccessFile, l, 1, 1, 1, false);
            if (byArray3.length == 512) {
                System.arraycopy(byArray3, 2, byArray2, 0, byArray2.length);
                for (n = 0; n < byArray2.length && (byArray2[n] & 0xFF) == 74; ++n) {
                }
                if (n == byArray2.length) {
                    return 3;
                }
            }
            byArray3 = null;
            byArray3 = this.readSectors(randomAccessFile, l, 37, 1, 2, false);
            if (byArray3.length == 2048 && (byArray3[814] & 0xFF) == 254 && (byArray3[815] & 0xFF) == 254 && (byArray3[816] & 0xFF) == 254 && (byArray3[817] & 0xFF) == 254 && (byArray3[818] & 0xFF) == 254 && (byArray3[819] & 0xFF) == 254 && (byArray3[820] & 0xFF) == 254 && (byArray3[821] & 0xFF) == 254 && (byArray3[822] & 0xFF) == 254 && (byArray3[823] & 0xFF) == 254 && (byArray3[824] & 0xFF) == 254 && (byArray3[825] & 0xFF) == 254 && (byArray3[826] & 0xFF) == 254 && (byArray3[827] & 0xFF) == 254 && (byArray3[828] & 0xFF) == 254 && (byArray3[829] & 0xFF) == 254 && (byArray3[830] & 0xFF) == 254 && (byArray3[831] & 0xFF) == 254 && (byArray3[832] & 0xFF) == 254 && (byArray3[833] & 0xFF) == 254 && (byArray3[834] & 0xFF) == 254 && (byArray3[835] & 0xFF) == 254) {
                return 4;
            }
            byArray3 = null;
            byArray3 = this.readSectors(randomAccessFile, l, 37, 14, 1, false);
            if (byArray3.length <= 0 || byArray3.length != 256) {
                return 0;
            }
            if ((byArray3[74] & 0xFF) != 254 || (byArray3[75] & 0xFF) != 254) {
                return 0;
            }
            byArray3 = null;
            byArray3 = this.readSectors(randomAccessFile, l, 0, 2, 1, false);
            if (byArray3.length <= 0 || byArray3.length != 256) {
                return 0;
            }
            int n3 = byArray3.length;
            for (n = 0; n < n3 - 24; ++n) {
                if ((byArray3[n] & 0xFF) != 80) continue;
                for (n2 = 0; n2 <= 23; ++n2) {
                    byArray[n2] = byArray3[n + n2];
                }
                string = this.alterFileName(byArray);
                if (!string.equals("PC-8001 Micro Disk Basic")) continue;
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "checkDiskFormat Other Error...";
            return -1;
        }
    }

    private byte[] readSectors(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, boolean bl) {
        byte[] byArray = new byte[]{};
        boolean bl2 = false;
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        boolean bl3 = false;
        String string = new String("");
        long[] lArray = new long[164];
        try {
            int n4 = 0;
            int n5 = 0;
            byte[] byArray2 = new byte[]{};
            if (n < 0 || n > 163) {
                this.mstrErrMsg = "readSectors TrackNo not 0-163";
                return byArray;
            }
            if (n2 < 1 || n2 > 20) {
                this.mstrErrMsg = "readSectors SectorNo not 1-20";
                return byArray;
            }
            if (!this.checkDiskHeader(randomAccessFile, l)) {
                return byArray;
            }
            string = this.mstrDiskName;
            int n6 = this.mintWriteProtect;
            int n7 = this.mintDiskType;
            int n8 = this.mintDiskSize;
            System.arraycopy(this.mlngFileTracks, 0, lArray, 0, this.mlngFileTracks.length);
            if (lArray[n] == 0L) {
                this.mstrErrMsg = "readSectors TrackNo not Exist";
                return byArray;
            }
            block2: while (n4 < n3) {
                randomAccessFile.seek(l + lArray[n]);
                int n9 = n;
                int n10 = 1;
                while (n == n9) {
                    nArray[0] = randomAccessFile.readUnsignedByte();
                    nArray[1] = randomAccessFile.readUnsignedByte();
                    nArray[2] = randomAccessFile.readUnsignedByte();
                    nArray[3] = randomAccessFile.readUnsignedByte();
                    nArray2[0] = randomAccessFile.readUnsignedByte();
                    nArray2[1] = randomAccessFile.readUnsignedByte();
                    int n11 = (nArray2[1] << 8) + (nArray2[0] << 0);
                    int n12 = randomAccessFile.readUnsignedByte();
                    int n13 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    nArray3[0] = randomAccessFile.readUnsignedByte();
                    nArray3[1] = randomAccessFile.readUnsignedByte();
                    n5 = (nArray3[1] << 8) + (nArray3[0] << 0);
                    byte[] byArray3 = new byte[n5];
                    randomAccessFile.readFully(byArray3);
                    if (n13 == 0) {
                        int n14 = n / 2;
                        int n15 = n % 2;
                        int n16 = n2;
                        if (nArray[0] == n14 && nArray[1] == n15 && nArray[2] == n16 && n16 == n10) {
                            byte[] byArray4 = new byte[byArray2.length];
                            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                            byArray2 = new byte[byArray4.length + n5];
                            System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                            System.arraycopy(byArray3, 0, byArray2, byArray4.length, byArray3.length);
                            bl3 = true;
                            if (++n4 >= n3) continue block2;
                        }
                    }
                    if (n11 <= n10) {
                        if (!bl) {
                            this.mstrErrMsg = "readSectors read Few Tracks";
                            return byArray;
                        }
                        if (bl3) {
                            if (n < 163) {
                                if (lArray[n + 1] != 0L) {
                                    ++n;
                                    n2 = 1;
                                    n10 = 1;
                                    continue;
                                }
                                this.mstrErrMsg = "readSectors EOF Tracks";
                                return byArray;
                            }
                            this.mstrErrMsg = "readSectors TrackNo 163 Over";
                            return byArray;
                        }
                        this.mstrErrMsg = "readSectors Sector not found";
                        return byArray;
                    }
                    ++n10;
                    if (!bl3) continue;
                    ++n2;
                }
            }
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "readSectors Other Error...";
            return byArray;
        }
    }

    private byte[] getFileBytes(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray = new byte[]{};
        boolean bl2 = false;
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        boolean bl3 = false;
        String string = new String("");
        long[] lArray = new long[164];
        try {
            int n5 = 0;
            byte[] byArray2 = new byte[]{};
            if (n < 0 || n > 163) {
                this.mstrErrMsg = "getFileBytes TrackNo not 0-163";
                return byArray;
            }
            if (n2 < 1 || n2 > 20) {
                this.mstrErrMsg = "getFileBytes SectorNo not 1-20";
                return byArray;
            }
            if (n4 <= 0) {
                this.mstrErrMsg = "getFileBytes intBytes under 0 Byte";
                return byArray;
            }
            if (!this.checkDiskHeader(randomAccessFile, l)) {
                return byArray;
            }
            string = this.mstrDiskName;
            int n6 = this.mintWriteProtect;
            int n7 = this.mintDiskType;
            int n8 = this.mintDiskSize;
            System.arraycopy(this.mlngFileTracks, 0, lArray, 0, this.mlngFileTracks.length);
            if (lArray[n] == 0L) {
                this.mstrErrMsg = "getFileBytes TrackNo not Exist";
                return byArray;
            }
            block2: while (byArray2.length < n4) {
                randomAccessFile.seek(l + lArray[n]);
                int n9 = n;
                int n10 = 1;
                while (n == n9) {
                    nArray[0] = randomAccessFile.readUnsignedByte();
                    nArray[1] = randomAccessFile.readUnsignedByte();
                    nArray[2] = randomAccessFile.readUnsignedByte();
                    nArray[3] = randomAccessFile.readUnsignedByte();
                    nArray2[0] = randomAccessFile.readUnsignedByte();
                    nArray2[1] = randomAccessFile.readUnsignedByte();
                    int n11 = (nArray2[1] << 8) + (nArray2[0] << 0);
                    int n12 = randomAccessFile.readUnsignedByte();
                    int n13 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    n12 = randomAccessFile.readUnsignedByte();
                    nArray3[0] = randomAccessFile.readUnsignedByte();
                    nArray3[1] = randomAccessFile.readUnsignedByte();
                    n5 = (nArray3[1] << 8) + (nArray3[0] << 0);
                    byte[] byArray3 = new byte[n5];
                    randomAccessFile.readFully(byArray3);
                    if (n13 == 0) {
                        int n14 = n / 2;
                        int n15 = n % 2;
                        int n16 = n2;
                        if (nArray[0] == n14 && nArray[1] == n15 && nArray[2] == n16 && n16 == n10) {
                            byte[] byArray4;
                            if (!bl3) {
                                if (byArray3.length <= n3) {
                                    this.mstrErrMsg = "getFileBytes intSeekByte greater than ReadSector";
                                    return byArray;
                                }
                                byArray4 = new byte[byArray3.length - n3];
                                System.arraycopy(byArray3, n3, byArray4, 0, byArray3.length - n3);
                            } else {
                                byte[] byArray5 = new byte[byArray2.length];
                                System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
                                byArray4 = new byte[byArray5.length + n5];
                                System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length);
                                System.arraycopy(byArray3, 0, byArray4, byArray5.length, byArray3.length);
                            }
                            bl3 = true;
                            if (byArray4.length >= n4) {
                                byArray2 = new byte[n4];
                                System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
                                continue block2;
                            }
                            byArray2 = new byte[byArray4.length];
                            System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                        }
                    }
                    if (n11 <= n10) {
                        if (!bl) {
                            this.mstrErrMsg = "getFileBytes read Few Tracks";
                            return byArray;
                        }
                        if (bl3) {
                            if (n < 163) {
                                if (lArray[n + 1] != 0L) {
                                    ++n;
                                    n2 = 1;
                                    n10 = 1;
                                    continue;
                                }
                                this.mstrErrMsg = "getFileBytes EOF Tracks";
                                return byArray;
                            }
                            this.mstrErrMsg = "getFileBytes TrackNo 163 Over";
                            return byArray;
                        }
                        this.mstrErrMsg = "getFileBytes Sector not found";
                        return byArray;
                    }
                    ++n10;
                    if (!bl3) continue;
                    ++n2;
                }
            }
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getFileBytes Other Error...";
            return byArray;
        }
    }

    private String alterFileName(byte[] byArray) {
        String string = new String("");
        try {
            int n;
            for (n = byArray.length - 1; n >= 0 && ((byArray[n] & 0xFF) == 0 || (byArray[n] & 0xFF) == 32); --n) {
            }
            if (n < 0) {
                this.mstrErrMsg = "alterFileName All Spaces Error.";
                return "";
            }
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, 0, byArray2, 0, n + 1);
            for (n = 0; n < byArray2.length; ++n) {
                int n2 = byArray2[n] & 0xFF;
                if (n2 < 32 || n2 >= 224) {
                    byArray2[n] = 95;
                    continue;
                }
                if (this.mstrEncoding.equals("MS932")) {
                    if (n2 < 127 || n2 > 160) continue;
                    byArray2[n] = 95;
                    continue;
                }
                if (n2 < 127) continue;
                byArray2[n] = 95;
            }
            string = new String(byArray2, this.mstrEncoding);
            return string;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "alterFileName Other Error...";
            return "";
        }
    }

    private String toDosFileName(String string) {
        String string2 = new String("");
        try {
            byte[] byArray = string.getBytes(this.mstrEncoding);
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                if (n != 32 && n != 58 && n != 42 && n != 63 && n != 124 && n != 34 && n != 59 && n != 60 && n != 62 && n != 47 && n != 92) continue;
                byArray[i] = 95;
            }
            string2 = new String(byArray, this.mstrEncoding);
            return string2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "toDosFileName Other Error...";
            return "";
        }
    }

    private byte[] getBasicText(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 0, 0, 0, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 0, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 1};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Vector<String> vector = new Vector<String>();
        vector.addElement("");
        vector.addElement("END");
        vector.addElement("FOR");
        vector.addElement("NEXT");
        vector.addElement("DATA");
        vector.addElement("INPUT");
        vector.addElement("DIM");
        vector.addElement("READ");
        vector.addElement("LET");
        vector.addElement("GOTO");
        vector.addElement("RUN");
        vector.addElement("IF");
        vector.addElement("RESTORE");
        vector.addElement("GOSUB");
        vector.addElement("RETURN");
        vector.addElement("REM");
        vector.addElement("STOP");
        vector.addElement("PRINT");
        vector.addElement("CLEAR");
        vector.addElement("LIST");
        vector.addElement("NEW");
        vector.addElement("ON");
        vector.addElement("WAIT");
        vector.addElement("DEF");
        vector.addElement("POKE");
        vector.addElement("CONT");
        vector.addElement("OUT");
        vector.addElement("LPRINT");
        vector.addElement("LLIST");
        vector.addElement("CONSOLE");
        vector.addElement("WIDTH");
        vector.addElement("ELSE");
        vector.addElement("TRON");
        vector.addElement("TROFF");
        vector.addElement("SWAP");
        vector.addElement("ERASE");
        vector.addElement("EDIT");
        vector.addElement("ERROR");
        vector.addElement("RESUME");
        vector.addElement("DELETE");
        vector.addElement("AUTO");
        vector.addElement("RENUM");
        vector.addElement("DEFSTR");
        vector.addElement("DEFINT");
        vector.addElement("DEFSNG");
        vector.addElement("DEFDBL");
        vector.addElement("LINE");
        vector.addElement("WHILE");
        vector.addElement("WEND");
        vector.addElement("CALL");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("WRITE");
        vector.addElement("COMMON");
        vector.addElement("CHAIN");
        vector.addElement("OPTION");
        vector.addElement("RANDOMIZE");
        vector.addElement("DSKO$");
        vector.addElement("OPEN");
        vector.addElement("FIELD");
        vector.addElement("GET");
        vector.addElement("PUT");
        vector.addElement("SET");
        vector.addElement("CLOSE");
        vector.addElement("LOAD");
        vector.addElement("MERGE");
        vector.addElement("FILES");
        vector.addElement("NAME");
        vector.addElement("KILL");
        vector.addElement("LSET");
        vector.addElement("RSET");
        vector.addElement("SAVE");
        vector.addElement("LFILES");
        vector.addElement("MON");
        vector.addElement("COLOR");
        vector.addElement("CIRCLE");
        vector.addElement("COPY");
        vector.addElement("CLS");
        vector.addElement("PSET");
        vector.addElement("PRESET");
        vector.addElement("PAINT");
        vector.addElement("TERM");
        vector.addElement("SCREEN");
        vector.addElement("BLOAD");
        vector.addElement("BSAVE");
        vector.addElement("LOCATE");
        vector.addElement("BEEP");
        vector.addElement("ROLL");
        vector.addElement("HELP");
        vector.addElement("");
        vector.addElement("KANJI");
        vector.addElement("TO");
        vector.addElement("THEN");
        vector.addElement("TAB(");
        vector.addElement("STEP");
        vector.addElement("USR");
        vector.addElement("FN");
        vector.addElement("SPC(");
        vector.addElement("NOT");
        vector.addElement("ERL");
        vector.addElement("ERR");
        vector.addElement("STRING$");
        vector.addElement("USING");
        vector.addElement("INSTR");
        vector.addElement("'");
        vector.addElement("VARPTR");
        vector.addElement("ATTR$");
        vector.addElement("DSKI$");
        vector.addElement("SRQ");
        vector.addElement("OFF");
        vector.addElement("INKEY$");
        vector.addElement(">");
        vector.addElement("=");
        vector.addElement("<");
        vector.addElement("+");
        vector.addElement("-");
        vector.addElement("*");
        vector.addElement("/");
        vector.addElement("^");
        vector.addElement("AND");
        vector.addElement("OR");
        vector.addElement("XOR");
        vector.addElement("EQV");
        vector.addElement("IMP");
        vector.addElement("MOD");
        vector.addElement("\\");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("LEFT$");
        vector.addElement("RIGHT$");
        vector.addElement("MID$");
        vector.addElement("SGN");
        vector.addElement("INT");
        vector.addElement("ABS");
        vector.addElement("SQR");
        vector.addElement("RND");
        vector.addElement("SIN");
        vector.addElement("LOG");
        vector.addElement("EXP");
        vector.addElement("COS");
        vector.addElement("TAN");
        vector.addElement("ATN");
        vector.addElement("FRE");
        vector.addElement("INP");
        vector.addElement("POS");
        vector.addElement("LEN");
        vector.addElement("STR$");
        vector.addElement("VAL");
        vector.addElement("ASC");
        vector.addElement("CHR$");
        vector.addElement("PEEK");
        vector.addElement("SPACE$");
        vector.addElement("OCT$");
        vector.addElement("HEX$");
        vector.addElement("LPOS");
        vector.addElement("CINT");
        vector.addElement("CSNG");
        vector.addElement("CDBL");
        vector.addElement("FIX");
        vector.addElement("CVI");
        vector.addElement("CVS");
        vector.addElement("CVD");
        vector.addElement("EOF");
        vector.addElement("LOC");
        vector.addElement("LOF");
        vector.addElement("FPOS");
        vector.addElement("MKI$");
        vector.addElement("MKS$");
        vector.addElement("MKD$");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("DSKF");
        vector.addElement("VIEW");
        vector.addElement("WINDOW");
        vector.addElement("POINT");
        vector.addElement("CSRLIN");
        vector.addElement("MAP");
        vector.addElement("SEARCH");
        vector.addElement("MOTOR");
        vector.addElement("PEN");
        vector.addElement("DATE$");
        vector.addElement("COM");
        vector.addElement("KEY");
        vector.addElement("TIME$");
        vector.addElement("WBYTE");
        vector.addElement("RBYTE");
        vector.addElement("POLL");
        vector.addElement("ISET");
        vector.addElement("IEEE");
        vector.addElement("IRESET");
        vector.addElement("STATUS");
        vector.addElement("CMD");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        vector.addElement("");
        byte[] byArray2 = new byte[]{};
        String string = new String("");
        try {
            int n3 = 0;
            while (n3 < n) {
                byte[] byArray3;
                int n4 = n2 == 2 ? ((byArray[n3 + 1] & 0xFF) - 128 << 8) + ((byArray[n3] & 0xFF) - 32 << 0) : ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0);
                n3 += 2;
                if (n4 <= 0) break;
                byte[] byArray4 = new byte[]{};
                int n5 = ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0);
                n3 += 2;
                new Integer(n5);
                string = Integer.toString(n5) + " ";
                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                block8: while (n3 < n) {
                    int n6 = byArray[n3] & 0xFF;
                    ++n3;
                    if (n6 == 0) break;
                    if (n6 == 34) {
                        bl = !bl;
                    }
                    if (bl || bl2) {
                        byArray4 = this.addStringBuffer(byArray4, n6);
                        continue;
                    }
                    if (n6 == 58) {
                        if (bl3) {
                            bl3 = false;
                        }
                        if ((byArray[n3] & 0xFF) == 143 && (byArray[n3 + 1] & 0xFF) == 233) {
                            byArray4 = this.addStringBuffer(byArray4, 39);
                            bl2 = true;
                            n3 += 2;
                            continue;
                        }
                        if ((byArray[n3] & 0xFF) == 159) {
                            byArray4 = this.addStringBuffer(byArray4, "ELSE".getBytes(this.mstrEncoding));
                            ++n3;
                            continue;
                        }
                    }
                    if (bl3) {
                        byArray4 = this.addStringBuffer(byArray4, n6);
                        continue;
                    }
                    switch (nArray[n6]) {
                        case 0: {
                            if (bl) {
                                byArray4 = this.addStringBuffer(byArray4, n6);
                                continue block8;
                            }
                            new Integer(n6);
                            string = "(UnknownCode: 0x" + Integer.toHexString(n6).toUpperCase() + ")";
                            byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                            continue block8;
                        }
                        case 1: {
                            int n7;
                            int n8;
                            double d;
                            double d2;
                            int n9;
                            if (n6 == 28 || n6 == 14) {
                                n5 = ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0);
                                n3 += 2;
                                new Integer(n5);
                                string = Integer.toString(n5);
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 11) {
                                n5 = ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0);
                                n3 += 2;
                                new Integer(n5);
                                string = "&O" + Integer.toOctalString(n5);
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 12) {
                                n5 = ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0);
                                n3 += 2;
                                new Integer(n5);
                                string = "&H" + Integer.toHexString(n5).toUpperCase();
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 13) {
                                n5 = ((byArray[n3 + 1] & 0xFF) << 8) + ((byArray[n3] & 0xFF) << 0) + 3;
                                n3 += 2;
                                new Integer(n5);
                                string = Integer.toString(n5);
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 15) {
                                new Integer(byArray[n3] & 0xFF);
                                string = Integer.toString(byArray[n3] & 0xFF);
                                ++n3;
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 >= 17 && n6 <= 27) {
                                new Integer(n6 - 17);
                                string = Integer.toString(n6 - 17);
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 29) {
                                n9 = byArray[n3 + 3] & 0xFF & 0x7F;
                                if ((n9 & 0x40) > 0) {
                                    n9 |= 0xFFFFFF80;
                                }
                                d2 = 0.5;
                                d = 0.5;
                                for (n8 = 2; n8 >= 0; --n8) {
                                    n5 = byArray[n3 + n8] & 0xFF;
                                    for (n7 = 0; n7 < 8; ++n7) {
                                        if ((n5 & 0x80) > 0) {
                                            d2 += d;
                                        }
                                        d /= 2.0;
                                        n5 <<= 1;
                                    }
                                }
                                n5 = 1;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    n5 *= 2;
                                }
                                if ((d2 *= (double)n5) * 10.0 % 10.0 != 0.0) {
                                    string = new DecimalFormat("################################################################################################0.0000000").format(d2);
                                    n5 = string.indexOf(".");
                                    for (n8 = string.length() - 1; n8 < n5 && !string.substring(n8, n8 + 1).equals("0"); --n8) {
                                    }
                                    string = string.substring(0, n8);
                                } else {
                                    string = new DecimalFormat("################################################################################################0").format(d2);
                                    string = string + "!";
                                }
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                n3 += 4;
                                continue block8;
                            }
                            if (n6 == 31) {
                                n9 = byArray[n3 + 7] & 0xFF & 0x7F;
                                if ((n9 & 0x40) > 0) {
                                    n9 |= 0xFFFFFF80;
                                }
                                d2 = 0.5;
                                d = 0.5;
                                for (n8 = 6; n8 >= 0; --n8) {
                                    n5 = byArray[n3 + n8] & 0xFF;
                                    for (n7 = 0; n7 < 8; ++n7) {
                                        if ((n5 & 0x80) > 0) {
                                            d2 += d;
                                        }
                                        d /= 2.0;
                                        n5 <<= 1;
                                    }
                                }
                                n5 = 1;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    n5 *= 2;
                                }
                                string = new DecimalFormat("################################################################################################0.0##############").format(d2 *= (double)n5);
                                string = string + "#";
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                n3 += 8;
                                continue block8;
                            }
                            if (n6 == 255) {
                                n6 = byArray[n3] & 0xFF;
                                ++n3;
                                if (nArray2[n6] == 0) {
                                    new Integer(n6);
                                    string = "(UnknownFunction: 0x" + Integer.toHexString(n6).toUpperCase() + ")";
                                    byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                    continue block8;
                                }
                                string = (String)vector.elementAt(n6);
                                byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                                continue block8;
                            }
                            if (n6 == 10) {
                                byArray3 = new byte[]{13, 10};
                                byArray4 = this.addStringBuffer(byArray4, byArray3);
                                continue block8;
                            }
                            if (n6 == 143) {
                                n6 = byArray[n3] & 0xFF;
                                ++n3;
                                continue block8;
                            }
                            new Integer(n6);
                            string = "(Unknown ???: 0x" + Integer.toHexString(n6).toUpperCase() + ")";
                            byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                            continue block8;
                        }
                        case 2: {
                            byArray4 = this.addStringBuffer(byArray4, n6);
                            continue block8;
                        }
                    }
                    string = (String)vector.elementAt(n6 - 128);
                    byArray4 = this.addStringBuffer(byArray4, string.getBytes(this.mstrEncoding));
                    if (n6 == 175 && (byArray[n3] & 0xFF) == 243) {
                        ++n3;
                    }
                    if (n6 == 132) {
                        bl3 = true;
                    }
                    if (n6 == 143) {
                        bl2 = true;
                    }
                    if (n6 != 145 || (byArray[n3] & 0xFF) == 32 || (byArray[n3] & 0xFF) == 35 || (byArray[n3] & 0xFF) == 34 || (byArray[n3] & 0xFF) == 58 || (byArray[n3] & 0xFF) == 0) continue;
                    byArray3 = new byte[]{32};
                    byArray4 = this.addStringBuffer(byArray4, byArray3);
                }
                byArray3 = new byte[]{13, 10};
                byArray4 = this.addStringBuffer(byArray4, byArray3);
                byArray3 = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                byArray2 = new byte[byArray3.length + byArray4.length];
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray4, 0, byArray2, byArray3.length, byArray4.length);
            }
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getBasicText Other Error...";
            byArray2 = new byte[]{};
            return byArray2;
        }
    }

    private byte[] addStringBuffer(byte[] byArray, int n) {
        try {
            if (byArray.length >= 1024) {
                return byArray;
            }
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = (byte)n;
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "addStringBuffer Other Error...";
            return byArray;
        }
    }

    private byte[] addStringBuffer(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length >= 1024) {
                return byArray;
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "addStringBuffer Other Error...";
            return byArray;
        }
    }

    private int getN88FileSize(RandomAccessFile randomAccessFile, long l, int n) {
        byte[] byArray = new byte[192];
        try {
            byte[] byArray2 = null;
            byArray2 = this.readSectors(randomAccessFile, l, 37, 14, 1, false);
            if (byArray2.length <= 0 || byArray2.length != 256) {
                this.mstrErrMsg = "getN88FileSize FAT Error.";
                return 0;
            }
            int n2 = n;
            int n3 = 0;
            int n4 = 1;
            while (true) {
                if (n2 > 192 || byArray[n2] == 1) {
                    this.mstrErrMsg = "getN88FileSize FAT Error.";
                    return 0;
                }
                if ((byArray2[n2] & 0xFF) >= 192) break;
                n3 += 2048;
                byArray[n2] = 1;
                n2 = byArray2[n2] & 0xFF;
                ++n4;
            }
            return n3 += (byArray2[n2] & 0xFF & 0xF) * 256;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getN88FileSize Other Error...";
            return 0;
        }
    }

    private byte[] getN88FileBytes(RandomAccessFile randomAccessFile, long l, int n) {
        byte[] byArray = new byte[192];
        byte[] byArray2 = new byte[]{};
        try {
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5 = null;
            byArray5 = this.readSectors(randomAccessFile, l, 37, 14, 1, false);
            if (byArray5.length <= 0 || byArray5.length != 256) {
                this.mstrErrMsg = "getN88FileBytes FAT Error.";
                return byArray2;
            }
            int n2 = n;
            byte[] byArray6 = new byte[]{};
            int n3 = 1;
            while (true) {
                if (n2 > 192 || byArray[n2] == 1) {
                    this.mstrErrMsg = "getN88FileBytes FAT Error.";
                    return byArray2;
                }
                int n4 = n2 / 2;
                int n5 = n2 % 2 * 8 + 1;
                byArray4 = this.readSectors(randomAccessFile, l, n4, n5, 8, false);
                if (byArray4.length != 2048) {
                    this.mstrErrMsg = "getN88FileBytes FAT Error.";
                    return byArray2;
                }
                if ((byArray5[n2] & 0xFF) >= 192) break;
                byArray3 = new byte[byArray6.length];
                System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
                byArray6 = new byte[byArray3.length + byArray4.length];
                System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
                System.arraycopy(byArray4, 0, byArray6, byArray3.length, byArray4.length);
                byArray[n2] = 1;
                n2 = byArray5[n2] & 0xFF;
                ++n3;
            }
            int n6 = (byArray5[n2] & 0xFF & 0xF) * 256;
            byArray3 = new byte[byArray6.length];
            System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
            byArray6 = new byte[byArray3.length + n6];
            System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray6, byArray3.length, n6);
            return byArray6;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getN88FileBytes Other Error...";
            return byArray2;
        }
    }

    private byte[] getMagicalFileBytes(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2;
            byte[] byArray3 = this.readSectors(randomAccessFile, l, n, n2, n3, false);
            if (byArray3.length != n3 * 512) {
                this.mstrErrMsg = "getMagicalFileBytes DirEntry Get Error.";
                return byArray;
            }
            byte[] byArray4 = new byte[]{};
            int n5 = n3 * 512 - 3;
            for (int i = 0; i < n5; i += 3) {
                n = byArray3[i] & 0xFF;
                n2 = byArray3[i + 1] & 0xFF;
                n3 = byArray3[i + 2] & 0xFF;
                if (n == 0) break;
                byte[] byArray5 = this.readSectors(randomAccessFile, l, n, n2, n3, false);
                byArray2 = new byte[byArray4.length];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                byArray4 = new byte[byArray2.length + byArray5.length];
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                System.arraycopy(byArray5, 0, byArray4, byArray2.length, byArray5.length);
            }
            if (n4 > byArray4.length) {
                this.mstrErrMsg = "getMagicalFileBytes Get File Error.";
                return byArray;
            }
            byArray2 = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
            byArray4 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray4.length);
            return byArray4;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getMagicalFileBytes Other Error...";
            return byArray;
        }
    }

    private byte[] getFrostFileBytes(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[924];
        byte[] byArray2 = new byte[]{};
        try {
            byte[] byArray3;
            int n5;
            byte[] byArray4;
            byte[] byArray5 = null;
            byArray5 = this.readSectors(randomAccessFile, l, 37, 1, 2, false);
            if (byArray5.length != 2048) {
                this.mstrErrMsg = "getFrostFileBytes FAT Error.";
                return byArray2;
            }
            int n6 = n3 == 0 ? n * 11 + n2 * 2 - 2 : n * 11 + n2 * 2 - 1;
            byte[] byArray6 = new byte[]{};
            int n7 = 1;
            while (true) {
                if (n6 > 924 || byArray[n6] == 1) {
                    this.mstrErrMsg = "getFrostFileBytes FAT Error.";
                    return byArray2;
                }
                n = n6 / 11;
                n2 = n6 % 11 / 2 + 1;
                n3 = n6 % 11;
                n3 = n3 % 2 != 0 ? 512 : 0;
                byArray4 = this.getFileBytes(randomAccessFile, l, n, n2, n3, 512, false);
                if (byArray4.length != 512) {
                    this.mstrErrMsg = "getFrostFileBytes FAT Error.";
                    return byArray2;
                }
                if ((byArray5[n6 * 2] & 0xFF) == 253 && (byArray5[n6 * 2 + 1] & 0xFF) == 253) {
                    n5 = n4 % 512;
                    if (n5 == 0) {
                        n5 = 512;
                    }
                    break;
                }
                byArray3 = new byte[byArray6.length];
                System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
                byArray6 = new byte[byArray3.length + byArray4.length];
                System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
                System.arraycopy(byArray4, 0, byArray6, byArray3.length, byArray4.length);
                byArray[n6] = 1;
                n6 = (byArray5[n6 * 2] & 0xFF) * 11 + (byArray5[n6 * 2 + 1] & 0xFF) - 1;
                ++n7;
            }
            byArray3 = new byte[byArray6.length];
            System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
            byArray6 = new byte[byArray3.length + n5];
            System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray6, byArray3.length, n5);
            return byArray6;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "getFrostFileBytes Other Error...";
            return byArray2;
        }
    }

    public DiskResultSet listDisk() {
        long l = 0L;
        int n = 0;
        String string = new String("");
        boolean bl = false;
        Vector<DiskResult> vector = new Vector<DiskResult>();
        vector.setSize(0);
        if (!this.mblnCheckOK) {
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        if (this.mfileD88.length() == 0L) {
            if (this.mfileD88.canWrite()) {
                this.mstrErrMsg = "listDisk Select ObjectFile 0 Byte";
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            this.mstrErrMsg = "listDisk Select ObjectFile 0 Byte and Can't Write";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        try {
            int n2;
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "r");
            for (long i = 0L; i < l; i += (long)n2) {
                if (n >= 65) {
                    this.mstrErrMsg = "listDisk ObjectFile D88 Disk 64 Over";
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                if (!this.checkDiskHeader(randomAccessFile, i)) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                string = this.mstrDiskName;
                int n3 = this.mintWriteProtect;
                int n4 = this.mintDiskType;
                n2 = this.mintDiskSize;
                ++n;
                int n5 = this.checkDiskFormat(randomAccessFile, i);
                if (n5 < 0) {
                    this.mstrErrMsg = "listDisk DiskFomat Error";
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                if (n3 == 1) {
                    bl = true;
                }
                new Integer(n);
                DiskResult diskResult = new DiskResult(1, n, string, n3, n4, n5, n2, Integer.toString(n));
                vector.addElement(diskResult);
            }
            randomAccessFile.close();
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "listDisk Other Error...";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
    }

    public DiskResultSet extractDisk(String string) {
        Vector vector = new Vector();
        vector.setSize(0);
        try {
            if (!this.mblnCheckOK) {
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            int[] nArray = this.parseNumRange(string, 1, 0);
            if (nArray.length >= 1) {
                return this.extractDisk(nArray);
            }
            this.mstrErrMsg = "extractDisk parseNumRange Error";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "extractDisk Other Error...";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
    }

    public DiskResultSet extractDisk(int[] nArray) {
        long l = 0L;
        int n = 0;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        int n2 = 0;
        String string = new String("");
        String string2 = new String("");
        boolean bl = false;
        String string3 = new String("");
        boolean bl2 = false;
        Vector<DiskResult> vector = new Vector<DiskResult>();
        vector.setSize(0);
        if (!this.mblnCheckOK) {
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "extractDisk D88 Count 0";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        try {
            int n3;
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "r");
            for (long i = 0L; i < l; i += (long)n3) {
                int n4;
                if (!this.checkDiskHeader(randomAccessFile, i)) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                string3 = this.mstrDiskName;
                int n5 = this.mintWriteProtect;
                int n6 = this.mintDiskType;
                n3 = this.mintDiskSize;
                ++n;
                int n7 = this.checkDiskFormat(randomAccessFile, i);
                if (n7 < 0) {
                    this.mstrErrMsg = "extractDisk  DiskFomat Error";
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                bl = false;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (nArray[n4] != n) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                string = this.mfileD88.getCanonicalPath();
                if (this.mfileD88.getName().lastIndexOf(".") != -1) {
                    string2 = string.substring(string.lastIndexOf(".") + 1);
                    string = string.substring(0, string.lastIndexOf("."));
                } else {
                    string2 = "D88";
                }
                string = string + "_" + decimalFormat.format(n) + "." + string2;
                File file = new File(string);
                file.delete();
                file.delete();
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(file, "rw");
                randomAccessFile2.seek(0L);
                randomAccessFile.seek(i);
                byte[] byArray = new byte[n3];
                randomAccessFile.readFully(byArray);
                for (n4 = 16; n4 <= 25; ++n4) {
                    byArray[n4] = 0;
                }
                if (byArray[26] == 1) {
                    byArray[26] = 16;
                    bl2 = true;
                }
                randomAccessFile2.write(byArray);
                randomAccessFile2.close();
                ++n2;
                DiskResult diskResult = new DiskResult(2, n, string3, n5, n6, n7, n3, file.getName());
                vector.addElement(diskResult);
            }
            randomAccessFile.close();
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "extractDisk Other Error...";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
    }

    public DiskResultSet updateDisk(String string, int n, String string2) {
        Vector vector = new Vector();
        vector.setSize(0);
        try {
            if (!this.mblnCheckOK) {
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            if (n != 0 && n != 1 && n != 2) {
                this.mstrErrMsg = "updateDisk DiskType or WriteProtect Value Error...";
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            int[] nArray = n == 2 ? this.parseNumRange(string, 3, 0) : this.parseNumRange(string, 1, 0);
            if (nArray.length >= 1) {
                return this.updateDisk(nArray, n, string2);
            }
            this.mstrErrMsg = "updateDisk parseNumRange Error.";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "updateDisk Other Error...";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
    }

    public DiskResultSet updateDisk(int[] nArray, int n, String string) {
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String string2 = new String("");
        DecimalFormat decimalFormat = new DecimalFormat("00");
        int n3 = 0;
        String string3 = new String("");
        boolean bl = false;
        Vector<DiskResult> vector = new Vector<DiskResult>();
        vector.setSize(0);
        if (!this.mblnCheckOK) {
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "updateDisk D88 Count 0";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        try {
            if (!this.mfileD88.canWrite()) {
                this.mstrErrMsg = "updateDisk D88File Don't Write";
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            if (n != 0 && n != 1 && n != 2) {
                this.mstrErrMsg = "updateDisk intType Error...";
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            if (n == 2) {
                byArray = string.getBytes(this.mstrEncoding);
                if (byArray.length > 16 || byArray[0] == 0) {
                    this.mstrErrMsg = "updateDisk DiskName Length Error...";
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                if (this.mstrEncoding.equals("MS932")) {
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                } else {
                    string2 = this.alterFileName(byArray);
                    byArray = string2.getBytes(this.mstrEncoding);
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                }
            }
            if (!this.backupD88File()) {
                vector.setSize(0);
                DiskResultSet diskResultSet = new DiskResultSet(vector);
                return diskResultSet;
            }
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "rw");
            while (l2 < l) {
                int n4;
                if (!this.checkDiskHeader(randomAccessFile, l2)) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                string3 = this.mstrDiskName;
                int n5 = this.mintWriteProtect;
                int n6 = this.mintDiskType;
                int n7 = this.mintDiskSize;
                ++n2;
                int n8 = this.checkDiskFormat(randomAccessFile, l2);
                if (n8 < 0) {
                    this.mstrErrMsg = "updateDisk  DiskFomat Error";
                    randomAccessFile.close();
                    vector.setSize(0);
                    DiskResultSet diskResultSet = new DiskResultSet(vector);
                    return diskResultSet;
                }
                bl = false;
                if (nArray[0] == 0) {
                    bl = n != 2;
                } else {
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        if (nArray[n4] != n2) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    for (n4 = 16; n4 <= 25; ++n4) {
                        randomAccessFile.seek(l2 + (long)n4);
                        randomAccessFile.writeByte(0);
                    }
                    switch (n) {
                        case 0: {
                            randomAccessFile.seek(l2 + 26L);
                            randomAccessFile.writeByte(0);
                            ++n3;
                            new Integer(n5);
                            DiskResult diskResult = new DiskResult(4, n2, string3, 0, n6, n8, n7, Integer.toString(n5));
                            vector.addElement(diskResult);
                            break;
                        }
                        case 1: {
                            randomAccessFile.seek(l2 + 26L);
                            randomAccessFile.writeByte(16);
                            ++n3;
                            new Integer(n5);
                            DiskResult diskResult = new DiskResult(5, n2, string3, 16, n6, n8, n7, Integer.toString(n5));
                            vector.addElement(diskResult);
                            break;
                        }
                        case 2: {
                            randomAccessFile.seek(l2);
                            randomAccessFile.write(byArray2);
                            ++n3;
                            for (n4 = 15; byArray2[n4] == 0 && n4 >= 0; --n4) {
                                byArray2[n4] = 32;
                            }
                            string2 = new String(byArray2, this.mstrEncoding);
                            if (n5 == 1) {
                                randomAccessFile.seek(l2 + 26L);
                                randomAccessFile.writeByte(16);
                            }
                            DiskResult diskResult = new DiskResult(6, n2, string2, n5, n6, n8, n7, string3);
                            vector.addElement(diskResult);
                            randomAccessFile.close();
                            DiskResultSet diskResultSet = new DiskResultSet(vector);
                            return diskResultSet;
                        }
                        default: {
                            this.mstrErrMsg = "updateDisk intType Error.";
                            vector.setSize(0);
                            DiskResultSet diskResultSet = new DiskResultSet(vector);
                            return diskResultSet;
                        }
                    }
                }
                l2 += (long)n7;
            }
            randomAccessFile.close();
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "updateDisk Other Error...";
            vector.setSize(0);
            DiskResultSet diskResultSet = new DiskResultSet(vector);
            return diskResultSet;
        }
    }

    public FileResultSet listFile(String string) {
        Vector vector = new Vector();
        vector.setSize(0);
        try {
            if (!this.mblnCheckOK) {
                vector.setSize(0);
                FileResultSet fileResultSet = new FileResultSet(vector);
                return fileResultSet;
            }
            int[] nArray = this.parseNumRange(string, 3, 0);
            if (nArray.length == 1) {
                return this.listFile(nArray[0]);
            }
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "listFile Other Error...";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
    }

    public FileResultSet listFile(int n) {
        long l = 0L;
        int n2 = 0;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string = new String("");
        String string2 = new String("");
        Vector<FileResult> vector = new Vector<FileResult>();
        vector.setSize(0);
        if (!this.mblnCheckOK) {
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "listFile D88 Count 0";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        try {
            int n3;
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "r");
            block25: for (long i = 0L; i < l; i += (long)n3) {
                if (!this.checkDiskHeader(randomAccessFile, i)) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    FileResultSet fileResultSet = new FileResultSet(vector);
                    return fileResultSet;
                }
                string = this.mstrDiskName;
                int n4 = this.mintWriteProtect;
                int n5 = this.mintDiskType;
                n3 = this.mintDiskSize;
                ++n2;
                int n6 = this.checkDiskFormat(randomAccessFile, i);
                if (n6 < 0) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    FileResultSet fileResultSet = new FileResultSet(vector);
                    return fileResultSet;
                }
                if (n != n2) continue;
                int n7 = 0;
                switch (n6) {
                    case 1: {
                        int n8;
                        byte[] byArray = null;
                        byArray = this.readSectors(randomAccessFile, i, 37, 1, 12, false);
                        if (byArray.length != 3072) {
                            this.mstrErrMsg = "listFile N88 DirEntry Get Error.";
                            randomAccessFile.close();
                            vector.setSize(0);
                            FileResultSet fileResultSet = new FileResultSet(vector);
                            return fileResultSet;
                        }
                        byte[] byArray2 = new byte[6];
                        byte[] byArray3 = new byte[3];
                        for (int j = 0; j <= 192 && (n8 = j * 16) < 3072 && (byArray[n8] & 0xFF) != 255; ++j) {
                            if ((byArray[n8] & 0xFF) == 0) continue;
                            System.arraycopy(byArray, n8, byArray2, 0, 6);
                            System.arraycopy(byArray, n8 + 6, byArray3, 0, 3);
                            string2 = this.alterFileName(byArray2);
                            if (string2.equals("")) {
                                string2 = "______";
                            }
                            if ((byArray3[0] & 0xFF) != 32 || (byArray3[1] & 0xFF) != 32 || (byArray3[2] & 0xFF) != 32) {
                                string2 = string2 + "." + this.alterFileName(byArray3);
                            }
                            int n9 = byArray[n8 + 10] & 0xFF;
                            int n10 = n9 / 2;
                            int n11 = n9 % 2 * 8 + 1;
                            int n12 = this.getN88FileSize(randomAccessFile, i, n9);
                            int n13 = 0;
                            int n14 = 0;
                            int n15 = 0;
                            int n16 = 0;
                            int n17 = byArray[n8 + 9] & 0xFF;
                            switch (n17) {
                                case 128: {
                                    n17 = 2;
                                    break;
                                }
                                case 1: {
                                    n17 = 1;
                                    byte[] byArray4 = null;
                                    byArray4 = this.readSectors(randomAccessFile, i, n10, n11, 1, false);
                                    if (byArray4.length != 256) break;
                                    n13 = ((byArray4[1] & 0xFF) << 8) + ((byArray4[0] & 0xFF) << 0);
                                    n14 = ((byArray4[3] & 0xFF) << 8) + ((byArray4[2] & 0xFF) << 0) - 1;
                                    n15 = 65535;
                                    break;
                                }
                                case 0: {
                                    n17 = 3;
                                    break;
                                }
                                default: {
                                    n17 = 0;
                                }
                            }
                            new Integer(++n7);
                            FileResult fileResult = new FileResult(1, n7, string2, "", n17, n12, n13, n14, n15, n10, n11, n16, Integer.toString(n7));
                            vector.addElement(fileResult);
                        }
                        break block25;
                    }
                    case 2: {
                        int n18;
                        byte[] byArray = null;
                        byArray = this.readSectors(randomAccessFile, i, 37, 1, 12, false);
                        if (byArray.length != 3072) {
                            this.mstrErrMsg = "listFile MDB DirEntry Get Error.";
                            randomAccessFile.close();
                            vector.setSize(0);
                            FileResultSet fileResultSet = new FileResultSet(vector);
                            return fileResultSet;
                        }
                        byte[] byArray5 = new byte[6];
                        byte[] byArray6 = new byte[3];
                        for (int j = 0; j <= 192 && (n18 = j * 16) < 3072 && (byArray[n18] & 0xFF) != 255; ++j) {
                            if ((byArray[n18] & 0xFF) == 0) continue;
                            System.arraycopy(byArray, n18, byArray5, 0, 6);
                            System.arraycopy(byArray, n18 + 6, byArray6, 0, 3);
                            string2 = this.alterFileName(byArray5);
                            if (string2.equals("")) {
                                string2 = "______";
                            }
                            if ((byArray6[0] & 0xFF) != 32 || (byArray6[1] & 0xFF) != 32 || (byArray6[2] & 0xFF) != 32) {
                                string2 = string2 + "." + this.alterFileName(byArray6);
                            }
                            int n19 = byArray[n18 + 10] & 0xFF;
                            int n20 = n19 / 2;
                            int n21 = n19 % 2 * 8 + 1;
                            int n22 = this.getN88FileSize(randomAccessFile, i, n19);
                            int n23 = 0;
                            int n24 = 0;
                            int n25 = 0;
                            int n26 = 0;
                            int n27 = ((byArray[n18 + 12] & 0xFF) << 8) + ((byArray[n18 + 11] & 0xFF) << 0);
                            if (n27 == 65535) {
                                n27 = 2;
                            } else {
                                n23 = n27;
                                n24 = n23 + n22 - 1;
                                n25 = ((byArray[n18 + 14] & 0xFF) << 8) + ((byArray[n18 + 13] & 0xFF) << 0);
                                n27 = 1;
                            }
                            new Integer(++n7);
                            FileResult fileResult = new FileResult(1, n7, string2, "", n27, n22, n23, n24, n25, n20, n21, n26, Integer.toString(n7));
                            vector.addElement(fileResult);
                        }
                        break block25;
                    }
                    case 3: {
                        byte[] byArray = new byte[31];
                        Vector<String> vector2 = new Vector<String>();
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        int[] nArray3 = new int[1];
                        vector2.addElement("");
                        nArray[0] = 1;
                        nArray2[0] = 2;
                        nArray3[0] = 9;
                        int n28 = 0;
                        while (n28 + 1 <= vector2.size()) {
                            int n29;
                            int n30 = 512 * nArray3[n28];
                            int n31 = (n30 - 144) / 16;
                            byte[] byArray7 = null;
                            byArray7 = this.readSectors(randomAccessFile, i, nArray[n28], nArray2[n28], nArray3[n28], false);
                            if (byArray7.length != n30) {
                                this.mstrErrMsg = "listFile Magical DirEntry Get Error.";
                                randomAccessFile.close();
                                vector.setSize(0);
                                FileResultSet fileResultSet = new FileResultSet(vector);
                                return fileResultSet;
                            }
                            for (int j = 0; j <= n31 && (n29 = j * 48 + 144) < n30 && (byArray7[n29] & 0xFF) != 255; ++j) {
                                System.arraycopy(byArray7, n29 + 1, byArray, 0, 31);
                                string2 = this.alterFileName(byArray);
                                if (string2.equals("")) {
                                    string2 = "_______________________________";
                                }
                                int n32 = byArray7[n29] & 0xFF;
                                int n33 = byArray7[n29 + 45] & 0xFF;
                                int n34 = byArray7[n29 + 46] & 0xFF;
                                int n35 = byArray7[n29 + 47] & 0xFF;
                                int n36 = ((byArray7[n29 + 36] & 0xFF) << 8) + ((byArray7[n29 + 35] & 0xFF) << 0);
                                int n37 = ((byArray7[n29 + 34] & 0xFF) << 8) + ((byArray7[n29 + 33] & 0xFF) << 0);
                                int n38 = n37 + n36 - 1;
                                int n39 = ((byArray7[n29 + 38] & 0xFF) << 8) + ((byArray7[n29 + 37] & 0xFF) << 0);
                                switch (n32) {
                                    case 34: {
                                        n32 = 2;
                                        break;
                                    }
                                    case 42: {
                                        n32 = 2;
                                        break;
                                    }
                                    case 3: {
                                        n32 = 1;
                                        break;
                                    }
                                    case 11: {
                                        n32 = 1;
                                        break;
                                    }
                                    case 68: {
                                        n32 = 3;
                                        break;
                                    }
                                    case 5: {
                                        break;
                                    }
                                    default: {
                                        n32 = 0;
                                    }
                                }
                                if (n32 == 5) {
                                    int[] nArray4 = new int[vector2.size()];
                                    int[] nArray5 = new int[vector2.size()];
                                    int[] nArray6 = new int[vector2.size()];
                                    System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
                                    System.arraycopy(nArray2, 0, nArray5, 0, nArray2.length);
                                    System.arraycopy(nArray3, 0, nArray6, 0, nArray3.length);
                                    nArray = new int[vector2.size() + 1];
                                    nArray2 = new int[vector2.size() + 1];
                                    nArray3 = new int[vector2.size() + 1];
                                    System.arraycopy(nArray4, 0, nArray, 0, nArray4.length);
                                    System.arraycopy(nArray5, 0, nArray2, 0, nArray5.length);
                                    System.arraycopy(nArray6, 0, nArray3, 0, nArray6.length);
                                    nArray[vector2.size()] = n33;
                                    nArray2[vector2.size()] = n34;
                                    nArray3[vector2.size()] = byArray7[n29 + 47] & 0xFF;
                                    vector2.addElement((String)vector2.elementAt(n28) + this.toDosFileName(string2) + this.mstrSeparator);
                                    continue;
                                }
                                new Integer(++n7);
                                FileResult fileResult = new FileResult(1, n7, string2, (String)vector2.elementAt(n28), n32, n36, n37, n38, n39, n33, n34, n35, Integer.toString(n7));
                                vector.addElement(fileResult);
                            }
                            ++n28;
                        }
                        break block25;
                    }
                    case 4: {
                        int n40;
                        byte[] byArray = null;
                        byArray = this.readSectors(randomAccessFile, i, 37, 3, 4, false);
                        if (byArray.length != 3584) {
                            this.mstrErrMsg = "listFile Frost DirEntry Get Error.";
                            randomAccessFile.close();
                            vector.setSize(0);
                            FileResultSet fileResultSet = new FileResultSet(vector);
                            return fileResultSet;
                        }
                        byte[] byArray8 = new byte[6];
                        byte[] byArray9 = new byte[3];
                        for (int j = 0; j <= 224 && (n40 = j * 16) < 3584 && (byArray[n40] & 0xFF) != 255; ++j) {
                            if ((byArray[n40] & 0xFF) == 0) continue;
                            System.arraycopy(byArray, n40, byArray8, 0, 6);
                            System.arraycopy(byArray, n40 + 6, byArray9, 0, 3);
                            string2 = this.alterFileName(byArray8);
                            if (string2.equals("")) {
                                string2 = "______";
                            }
                            if ((byArray9[0] & 0xFF) != 32 || (byArray9[1] & 0xFF) != 32 || (byArray9[2] & 0xFF) != 32) {
                                string2 = string2 + "." + this.alterFileName(byArray9);
                            }
                            int n41 = byArray[n40 + 10] & 0xFF;
                            int n42 = ((byArray[n40 + 11] & 0xFF) - 1) / 2 + 1;
                            int n43 = ((byArray[n40 + 15] & 0xFF) << 8) + ((byArray[n40 + 14] & 0xFF) << 0);
                            int n44 = 0;
                            int n45 = 0;
                            int n46 = 0;
                            int n47 = (1 - (byArray[n40 + 11] & 0xFF) % 2) * 512;
                            int n48 = byArray[n40 + 9] & 0xFF;
                            switch (n48) {
                                case 0: {
                                    n48 = 2;
                                    break;
                                }
                                case 1: {
                                    n44 = ((byArray[n40 + 13] & 0xFF) << 8) + ((byArray[n40 + 12] & 0xFF) << 0);
                                    n45 = n44 + n43 - 1;
                                    n46 = 65535;
                                    n48 = 1;
                                    break;
                                }
                                default: {
                                    n48 = 0;
                                }
                            }
                            new Integer(++n7);
                            FileResult fileResult = new FileResult(1, n7, string2, "", n48, n43, n44, n45, n46, n41, n42, n47, Integer.toString(n7));
                            vector.addElement(fileResult);
                        }
                        break block25;
                    }
                    default: {
                        this.mstrErrMsg = "listFile UnRecognized.";
                        randomAccessFile.close();
                        vector.setSize(0);
                        FileResultSet fileResultSet = new FileResultSet(vector);
                        return fileResultSet;
                    }
                }
            }
            randomAccessFile.close();
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "listFile Other Error...";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
    }

    public FileResultSet extractFile(String string, String string2, boolean bl) {
        Vector vector = new Vector();
        vector.setSize(0);
        try {
            if (!this.mblnCheckOK) {
                vector.setSize(0);
                FileResultSet fileResultSet = new FileResultSet(vector);
                return fileResultSet;
            }
            int[] nArray = this.parseNumRange(string, 3, 0);
            if (nArray.length == 1) {
                return this.extractFile(nArray[0], string2, bl);
            }
            this.mstrErrMsg = "extractFile  Arg Error.";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "extractFile Other Error...";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
    }

    public FileResultSet extractFile(int n, String string, boolean bl) {
        Vector vector = new Vector();
        vector.setSize(0);
        try {
            if (!this.mblnCheckOK) {
                vector.setSize(0);
                FileResultSet fileResultSet = new FileResultSet(vector);
                return fileResultSet;
            }
            int[] nArray = this.parseNumRange(string, 1, n);
            return this.extractFile(n, nArray, bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "extractFile Other Error...";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
    }

    public FileResultSet extractFile(int n, int[] nArray, boolean bl) {
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string = new String("");
        String string2 = new String("");
        String string3 = new String("");
        boolean bl2 = false;
        String string4 = new String("");
        String string5 = new String("");
        String string6 = new String("");
        Vector<FileResult> vector = new Vector<FileResult>();
        vector.setSize(0);
        if (!this.mblnCheckOK) {
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "extractFile D88 Count 0";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        if (!this.mstrEncoding.equals("MS932") && bl) {
            this.mstrErrMsg = "extractFile Cut4Header true NG: " + this.mstrEncoding;
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        try {
            int n4;
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "r");
            for (long i = 0L; i < l; i += (long)n4) {
                if (!this.checkDiskHeader(randomAccessFile, i)) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    FileResultSet fileResultSet = new FileResultSet(vector);
                    return fileResultSet;
                }
                string = this.mstrDiskName;
                int n5 = this.mintWriteProtect;
                int n6 = this.mintDiskType;
                n4 = this.mintDiskSize;
                ++n2;
                int n7 = this.checkDiskFormat(randomAccessFile, i);
                if (n7 <= 0 || n7 >= 5) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    FileResultSet fileResultSet = new FileResultSet(vector);
                    return fileResultSet;
                }
                if (n != n2) continue;
                FileResultSet fileResultSet = this.listFile(n);
                if (fileResultSet.getMaxRows() <= 0) {
                    randomAccessFile.close();
                    vector.setSize(0);
                    FileResultSet fileResultSet2 = new FileResultSet(vector);
                    return fileResultSet2;
                }
                fileResultSet.next();
                n3 = 1;
                do {
                    int n8;
                    int n9 = fileResultSet.getFileNumber();
                    string4 = fileResultSet.getFileName();
                    string5 = fileResultSet.getFileDirName();
                    int n10 = fileResultSet.getFileType();
                    int n11 = fileResultSet.getFileSize();
                    int n12 = fileResultSet.getFileSAddr();
                    int n13 = fileResultSet.getFileEAddr();
                    int n14 = fileResultSet.getFileXAddr();
                    int n15 = fileResultSet.getFileTrack();
                    int n16 = fileResultSet.getFileSector();
                    int n17 = fileResultSet.getFileSeveral();
                    bl2 = false;
                    for (n8 = 0; n8 < nArray.length; ++n8) {
                        if (nArray[n8] != n3) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        FileResult fileResult;
                        string6 = this.toDosFileName(string4);
                        if (string6.equals("")) {
                            string6 = "______.___";
                        }
                        byte[] byArray = null;
                        switch (n7) {
                            case 1: 
                            case 2: {
                                int n18 = n15 * 2 + (n16 - 1) / 8;
                                byArray = this.getN88FileBytes(randomAccessFile, i, n18);
                                break;
                            }
                            case 3: {
                                byArray = this.getMagicalFileBytes(randomAccessFile, i, n15, n16, n17, n11);
                                break;
                            }
                            case 4: {
                                byArray = this.getFrostFileBytes(randomAccessFile, i, n15, n16, n17, n11);
                                break;
                            }
                            default: {
                                randomAccessFile.close();
                                vector.setSize(0);
                                FileResultSet fileResultSet3 = new FileResultSet(vector);
                                return fileResultSet3;
                            }
                        }
                        if (byArray.length != n11) {
                            fileResult = new FileResult(2, n3, string4, string5, n10, n11, n12, n13, n14, n15, n16, n17, "");
                            vector.addElement(fileResult);
                            ++n3;
                            continue;
                        }
                        if (bl) {
                            byte[] byArray2;
                            if (n10 == 2) {
                                byArray2 = this.getBasicText(byArray, n11, n7);
                                byArray = new byte[byArray2.length];
                                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                            } else if (n10 == 1 && (n7 == 1 || n7 == 2)) {
                                n8 = n13 - n12 + 1;
                                byArray2 = new byte[byArray.length];
                                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                                byArray = new byte[n8];
                                System.arraycopy(byArray2, 4, byArray, 0, byArray.length);
                            }
                        }
                        if ((string3 = this.mfileD88.getCanonicalPath()).lastIndexOf(".") > string3.lastIndexOf(this.mstrSeparator)) {
                            string2 = string3.substring(0, string3.lastIndexOf("."));
                        } else {
                            string3 = string3 + "_file";
                        }
                        File file = new File(string2);
                        if (file.exists() && !file.isDirectory()) {
                            randomAccessFile.close();
                            vector.setSize(0);
                            FileResultSet fileResultSet4 = new FileResultSet(vector);
                            return fileResultSet4;
                        }
                        file = new File(string2 = string2 + this.mstrSeparator + decimalFormat.format(n2));
                        if (file.exists() && !file.isDirectory()) {
                            randomAccessFile.close();
                            vector.setSize(0);
                            FileResultSet fileResultSet5 = new FileResultSet(vector);
                            return fileResultSet5;
                        }
                        file = new File(string2 = string2 + this.mstrSeparator + string5);
                        if (file.exists()) {
                            if (!file.isDirectory()) {
                                fileResult = new FileResult(2, n3, string4, string5, n10, n11, n12, n13, n14, n15, n16, n17, "");
                                vector.addElement(fileResult);
                                ++n3;
                                continue;
                            }
                        } else {
                            file.mkdirs();
                        }
                        string3 = string2 + string6;
                        File file2 = new File(string3);
                        file2.delete();
                        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
                        randomAccessFile2.seek(0L);
                        randomAccessFile2.write(byArray);
                        randomAccessFile2.close();
                        fileResult = new FileResult(2, n3, string4, string5, n10, n11, n12, n13, n14, n15, n16, n17, string3);
                        vector.addElement(fileResult);
                    }
                    ++n3;
                } while (fileResultSet.next());
                break;
            }
            randomAccessFile.close();
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "extractFile Other Error...";
            vector.setSize(0);
            FileResultSet fileResultSet = new FileResultSet(vector);
            return fileResultSet;
        }
    }

    public boolean dumpData(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (!this.mblnCheckOK) {
            return false;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "dumpData D88 Count 0";
            return false;
        }
        try {
            int[] nArray = this.parseNumRange(string, 3, 0);
            if (nArray.length == 1) {
                int n = new Integer(string2);
                int n2 = new Integer(string3);
                int n3 = new Integer(string4);
                int n4 = new Integer(string5);
                return this.dumpData(nArray[0], n, n2, n3, n4, bl);
            }
            this.mstrErrMsg = "dumpData Arg Error.";
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "dumpData Other Error...";
            return false;
        }
    }

    public boolean dumpData(int n, int n2, int n3, int n4, int n5, boolean bl) {
        long l = 0L;
        int n6 = 0;
        String string = new String("");
        String string2 = new String("");
        boolean bl2 = false;
        if (!this.mblnCheckOK) {
            return false;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "dumpData D88 Count 0";
            return false;
        }
        if (n < 1 || n > 64) {
            this.mstrErrMsg = "dumpData DiskNumber Error";
            return false;
        }
        try {
            int n7;
            l = this.mfileD88.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mfileD88, "r");
            bl2 = false;
            for (long i = 0L; i < l && !bl2; i += (long)n7) {
                if (!this.checkDiskHeader(randomAccessFile, i)) {
                    randomAccessFile.close();
                    return false;
                }
                string = this.mstrDiskName;
                int n8 = this.mintWriteProtect;
                int n9 = this.mintDiskType;
                n7 = this.mintDiskSize;
                ++n6;
                int n10 = this.checkDiskFormat(randomAccessFile, i);
                if (n10 < 0) {
                    this.mstrErrMsg = "dumpData DiskFomat Error";
                    randomAccessFile.close();
                    return false;
                }
                if (n == n6) {
                    bl2 = true;
                }
                if (!bl2) continue;
                byte[] byArray = this.getFileBytes(randomAccessFile, i, n2, n3, n4, n5, bl);
                if (byArray.length == 0) {
                    randomAccessFile.close();
                    return false;
                }
                if (n5 != byArray.length) {
                    this.mstrErrMsg = "dumpData intDumpSize Invalid.";
                    randomAccessFile.close();
                    return false;
                }
                string2 = this.mfileD88.getCanonicalPath();
                if (this.mfileD88.getName().lastIndexOf(".") != -1) {
                    string2 = string2.substring(0, string2.lastIndexOf("."));
                }
                string2 = string2 + "_DMP.DMP";
                File file = new File(string2);
                file.delete();
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(file, "rw");
                randomAccessFile2.seek(0L);
                randomAccessFile2.write(byArray);
                randomAccessFile2.close();
            }
            randomAccessFile.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "dumpData Other Error...";
            return false;
        }
    }

    private boolean backupD88File() {
        if (!this.mblnCheckOK) {
            return false;
        }
        if (this.mintDiskCount <= 0) {
            this.mstrErrMsg = "backupD88File D88 Count 0";
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        try {
            if (!this.mblnTranFlag) {
                if (!this.mblnBackupFlag) {
                    this.mfileD88BackUp = new File(this.mfileD88.getCanonicalPath() + ".backup." + simpleDateFormat.format(date));
                    if (!this.copyD88File(this.mfileD88BackUp)) {
                        return false;
                    }
                    this.mblnBackupFlag = true;
                }
                this.mblnTranFlag = true;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "backupD88 File Other Error";
            return false;
        }
    }

    private boolean copyD88File(File file) {
        if (!this.mblnCheckOK) {
            return false;
        }
        String string = new String("");
        try {
            file.delete();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(0L);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.mfileD88, "r");
            randomAccessFile2.seek(0L);
            byte[] byArray = new byte[(int)randomAccessFile2.length()];
            randomAccessFile2.readFully(byArray);
            randomAccessFile2.close();
            randomAccessFile.write(byArray);
            randomAccessFile.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.mstrErrMsg = "copyD88File Other Error..";
            return false;
        }
    }
}

